/*================================================================================
* ======== ОПИСАНИЕ ========
*
* Система дуэлей для Deathrun
* мода
*
* ========= ВАЖНО ==========
*
* Для корректной работы лагина
* используйте FREE и INVIS 
* из архива
*
* ======== ФУНКЦИИ =========
*
* 1. Стандартно 11 уникальных дуэлей
* 2. Гибкие настройки
* 3. Только последний кт сможет открыть меню
* 4. Корректная работа с ботами
* 5. Сервер не падает
* 6. Таймер и ограничения дуэли по времени
* 7. Анти-спавн килл
* 8. Встроеные информер
* 9. Худы не перебиваются
* 10. Открывает меню соледнему КТ
* 11. Музыка во время дуэли без закачки на клиент
* 12. Ожидание дуэли
* 13. Озвучивание отсчета
* 14. Различные эффекты
* 15. И многое другое
*
* == КОМАНДЫ ДЛЯ АДМИНА ==
*
*	dd_origin_menu
*		- Открыть меню точек телепортации
*
* == КОМАНДЫ ДЛЯ ИГРОКА ==
*
*	say /lr | !lr
*		- Открыть меню дуэлей
*
*	say /dd | !dd
*		- Открыть меню дуэлей
*
*	deathrun_duels
*		- Открыть меню дуэлей
*
* ===== ПЕРЕМЕННЫЕ ======
* 	
* dd_duels <флаги> [По умолчанию: abcdefghijkl]
* 	- Включение дуэлей
*	- a  На ножах
*	- b  Диглы
*	- c Гранаты
*	- d Скауты
*	- e Дробовики
*	- f Авп
*	- g Фамас
*	- h Русская Рулетка
*	- i Математическая
*	- j Словесная
*	- k Спреи
*	- l Дальность Дропа
*
* dd_music <0/1> [По умолчанию: 1]
*	- Музыка во время луэли
*	- 0 Выключена
*	- 1 Включена
*
* dd_timer <0/1> [По умолчанию: 1]
* 	- Таймер и ограничение дуэли во времени
*	- 0 Выключен
*	- 1 Включен
*
* dd_timelimit <секунды> [По умолчанию: 120]
*	- Ограничение дуэли во времени
*	- Только если dd_timer 1
*
* dd_spawngod <0/1> [По умолчанию: 1]
*	- Анти-спавн килл
*	- 0 Выключен
*	- 1 Включен
*
* dd_effects <1/2/3> [По умолчанию: 3]
* 	- Эффекты
*	- 1 Ауры
*	- 2 Волны
*	- 3 Ауры и волны
*
* dd_wait <секунды> [По умолчанию: 5]
* 	- Ожидание перед дуэлями
*
* dd_informer <0/1> [По умолчанию: 1]
* 	- HUD-Информер слева
*	- 0 Выключен
*	- 1 Включен
*
* dd_lastmenu <0/1> [По умолчанию: 1]
*	- Открытие меню c вопросом последнему CT
*	- 0 Выключен
*	- 1 Включен
*	- Только если dd_informer 1
*
* dd_telepot <0/1> [По умолчанию: 1]
*	- Телепортирование игроков в начале дуэли
*	- 0 Выключено
*	- 1 Включено
*
* === ИСТОРИЯ ИЗМЕНЕНИЙ ===
*
* 2.5:
*	- Добавлено телепортирование игроков
*
* 2.4:
*	- Fix Fix Fix
*
* 2.3:
*	- Фиксы ошибок
*	- Добавлена дуэль на фамасах
*
* 2.2:
*	- Фиксы ошибок
*
* 2.1:
*	- Фиксы ошибок
*
* 2.0:
*	- Первый частный релиз 
*
* 1.0..1.9:
*	- Ранние "рабочие" версии под названием Last Request by NoName
*
* =================================================================================*/
/*================================================================================
	Инклюды
=================================================================================*/
#include <amxmodx>
#include <amxmisc>
#include <cstrike>
#include <fakemeta>
#include <fakemeta_util>
#include <fun>
#include <hamsandwich>
//#include <deathrun_manager>
/*================================================================================
	Данные о плагине
=================================================================================*/
#define PLUGIN "Deathrun Duels"
#define VERSION "2.5"
#define AUTHOR "NoName"
#define PREFIX "!g[Дуэли]!y"

#define is_valid_player(%1) (1 <= %1 <= 32)
/*================================================================================
	Различные данные
=================================================================================*/
#define GODTID 100500
#define TIMERTID 100501
#define TIMER2TID 100502
#define INFORMERTID 100503
#define WAITTIMERTID 100504
#define MCOUNT 9
#define SCOUNT 20
#define DCOUNT 12
#define DAMMO 1
#define KWPN "world"
#define KHS 1
#define MENUBODY 1024
#define MAXORIGINS 2
#define MAXWORDS 100
/*================================================================================
	Константы
=================================================================================*/
new MaxPlayers
new ChoosedDuel
new DuelNum
new SayText
new BeaconSprite
new CounterID
new TerroristID
new MathAnswer
new RussianRouletteID
new RussianRouletteBullet
new Index
new Timer
new OriginsNum
new WordsNum

new g_MsgHud1
new g_MsgHud2
new g_MsgHud3

new PcvarDuels
new PcvarMusic
new PcvarTimer
new PcvarTimeLimit
new PcvarSpawnGod
new PcvarEffects
new PcvarInformer
new PcvarLastMenu
new PcvarWait
new PcvarMode
new PcvarTele

new MenuPosition[33]
new MenuTs[33]
new RussianRouletteName[64]
new MathTask[64]
new ConfigsDir[64]
new WordsFile[64]
new OriginsFile[128]
new WordAnswer[128]

new MenuBody[MENUBODY + 1]

new bool:Last
new bool:Duel
new bool:FPage
new bool:TouchWeapons[33]
new bool:Once[33]
new bool:InDuel[33]
new bool:Knife[33]
new bool:Deagle[33]
new bool:Grenade[33]
new bool:Scout[33]
new bool:Drob[33]
new bool:Awp[33]
new bool:Math[33]
new bool:Word[33]
new bool:RussianRoulette[33]
new bool:Used[33]
new bool:Boom[33]
new bool:NotYou[33]
new bool:DoIt[33]
new bool:Start[33]
new bool:Spray[33]
new bool:Guntoss[33]
new bool:Famas[33]

new Origins[MAXORIGINS][128]
new Words[MAXWORDS][192]

new Music[MCOUNT][] = 
{
	"media/Half-Life01.mp3",
	"media/Half-Life02.mp3",
	"media/Half-Life03.mp3",
	"media/Half-Life08.mp3",
	"media/Half-Life11.mp3",
	"media/Half-Life12.mp3",
	"media/Half-Life13.mp3",
	"media/Half-Life16.mp3",
	"media/Half-Life17.mp3"
}

new Sound[SCOUNT][] =
{
	"fvox/one",
	"fvox/two",
	"fvox/three",
	"fvox/four",
	"fvox/five",
	"fvox/six",
	"fvox/seven",
	"fvox/eight",
	"fvox/nine",
	"fvox/ten",
	"fvox/eleven",
	"fvox/twelve",
	"fvox/thirteen",
	"fvox/fourteen",
	"fvox/fifteen",
	"fvox/sixteen",
	"fvox/seventeen",
	"fvox/eighteen",
	"fvox/nineteen",
	"fvox/twenty"
}

new Duels[DCOUNT][] =
{
	"DUEL_1",
	"DUEL_2",
	"DUEL_3",
	"DUEL_4",
	"DUEL_5",
	"DUEL_6",
	"DUEL_7",
	"DUEL_8",
	"DUEL_9",
	"DUEL_10",
	"DUEL_11",
	"DUEL_12"
}
/*================================================================================
	Загрузка плагина
=================================================================================*/
public plugin_init()
{
	register_plugin(PLUGIN, VERSION, AUTHOR)
	register_event("HLTV", "RoundStart", "a", "1=0", "2=0")
	register_logevent("RoundEnd", 2, "1=Round_End")
	RegisterHam(Ham_Touch, "weaponbox", "TouchWeapon")
	RegisterHam(Ham_Touch, "armoury_entity", "TouchWeapon")
	RegisterHam(Ham_Touch, "weapon_shield", "TouchWeapon")
	RegisterHam(Ham_Spawn, "player", "PlayerSpawn", 1)
	RegisterHam(Ham_Killed, "player", "PlayerKilled")
	register_forward(FM_CmdStart,"CmdStart",1)
	register_forward(FM_UpdateClientData, "UpdateClientData", 1)
	register_clcmd("say /lr", "CmdDuelsMenu")
	register_clcmd("say /dd", "CmdDuelsMenu")
	register_clcmd("say_team /lr", "CmdDuelsMenu")
	register_clcmd("say_team /dd", "CmdDuelsMenu")
	register_clcmd("deathrun_duels", "CmdDuelsMenu")
	register_clcmd("say", "hooksay")
	register_clcmd("say_team", "hooksay_team")
	register_concmd("dd_origin_menu", "CmdOriginsMenu", ADMIN_RCON)
	PcvarDuels = register_cvar("dd_duels", "abcdefghijklm")
	PcvarMusic = register_cvar("dd_music", "0")
	PcvarTimer = register_cvar("dd_timer", "0")
	PcvarTimeLimit = register_cvar("dd_timelimit", "120")
	PcvarSpawnGod = register_cvar("dd_spawngod", "1")
	PcvarEffects = register_cvar("dd_effects", "3")
	PcvarWait = register_cvar("dd_wait", "5")
	PcvarInformer = register_cvar("dd_informer", "0")
	PcvarLastMenu = register_cvar("dd_lastmenu", "1")
	PcvarTele = register_cvar("dd_teleport", "1")
	PcvarMode = register_cvar("deathrun_mode", "BUTTONS", FCVAR_SERVER)
	register_cvar("Deathrun Duels", "v2.5 by NoName", FCVAR_SERVER|FCVAR_SPONLY)
	register_menucmd(register_menuid("Duels Menu"), MENUBODY - 1, "ActionDuelsMenu")
	register_menucmd(register_menuid("Enemy Menu"), MENUBODY - 1, "ActionEnemyMenu")
	register_menucmd(register_menuid("Roulette Menu"), MENUBODY - 1, "ActionRussianRouletteMenu")
	register_menucmd(register_menuid("Last Menu"), MENUBODY - 1, "ActionLastMenu")
	register_menucmd(register_menuid("Origins Menu"), MENUBODY - 1, "ActionOriginsMenu")
	SayText = get_user_msgid("SayText")
	MaxPlayers = get_maxplayers()
	g_MsgHud1 = CreateHudSyncObj()
	g_MsgHud2 = CreateHudSyncObj()
	g_MsgHud3 = CreateHudSyncObj()
	register_dictionary("deathrun_duels.txt")
	set_task(1.0, "Informer", INFORMERTID, "", 0, "b")
	return PLUGIN_CONTINUE
}
/*================================================================================
	Закачки плагина
=================================================================================*/
public plugin_precache() 
{	
	BeaconSprite = precache_model("sprites/shockwave.spr")
	get_configsdir(ConfigsDir, charsmax(ConfigsDir))
	format(WordsFile, charsmax(WordsFile), "%s/deathrun_duels.ini", ConfigsDir)
	new cmap[32], Len, dddir[128]
	format(dddir, 127, "%s/deathrun_duels", ConfigsDir)
	if(!dir_exists(dddir))
	{
		mkdir(dddir)
	}
	get_mapname(cmap, 31)
	format(OriginsFile, charsmax(OriginsFile), "%s/deathrun_duels/%s.ini", ConfigsDir, cmap)
	new i = 0
	if(file_exists(WordsFile))
	{
		while(i < MAXWORDS && read_file(WordsFile, i , Words[WordsNum], 191, Len))
		{
			i++
			if(Words[WordsNum][0] == ';' || Len == 0)
			{
				continue
			}
			WordsNum++
		}
	}
	i = 0
	if(file_exists(OriginsFile))
	{
		while(i < MAXORIGINS && read_file(OriginsFile, i ,Origins[OriginsNum], 127, Len))
		{
			i++
			if(Origins[OriginsNum][0] == ';' || Len == 0)
			{
				continue
			}
			OriginsNum++
		}
	}
	return PLUGIN_CONTINUE
}
/*================================================================================
	Начало раунда
=================================================================================*/
public RoundStart()
{
	Duel = false
	Last = false
	if(get_pcvar_num(PcvarTimer))
	{
		remove_task(TIMERTID)
	}
	remove_task(TIMER2TID)
	remove_task(WAITTIMERTID)
	set_pcvar_string(PcvarMode, "BUTTONS")
	return PLUGIN_CONTINUE
}
/*================================================================================
	Конец раунда
=================================================================================*/
public RoundEnd()
{
	if(get_pcvar_num(PcvarMusic))
	{
		client_cmd(0, "cd fadeout")
	}
	if(get_pcvar_num(PcvarTimer))
	{
		remove_task(TIMERTID)
	}
	remove_task(TIMER2TID)
	remove_task(WAITTIMERTID)
	return PLUGIN_CONTINUE
}
/*================================================================================
	Возрождение игрока
=================================================================================*/
public PlayerSpawn(id)
{
	if(!is_user_alive(id) || !cs_get_user_team(id) || is_user_bot(id))
	{
		return PLUGIN_CONTINUE
	}
	if(get_pcvar_num(PcvarSpawnGod))
	{
		set_pev(id, pev_takedamage, 0)
		set_task(3.0, "GodOff", id + GODTID)
	}
	set_user_rendering(id)
	remove_task(id)
	TouchWeapons[id] = false
	Once[id] = false
	Knife[id] = false
	Deagle[id] = false
	Grenade[id] = false
	Scout[id] = false
	Drob[id] = false
	Awp[id] = false
	Math[id] = false
	Word[id] = false
	RussianRoulette[id] = false
	Used[id] = false
	NotYou[id] = false
	DoIt[id] = false
	Start[id] = false
	Spray[id] = false
	Guntoss[id] = false
	InDuel[id] = false
	Famas[id] = false
	ChatColor(id, "%s %L", PREFIX, LANG_PLAYER, "SPAWN_MENU_INFO")
	if(cs_get_user_team(id) == CS_TEAM_T && !is_user_bot(id))
	{
		ChatColor(id, "%s %L", PREFIX, LANG_PLAYER, "SPAWN_YOU_TER")
		ChatColor(id, "%s %L", PREFIX, LANG_PLAYER, "SPAWN_TER_MODES")
	}
	return PLUGIN_CONTINUE
}	
/*================================================================================
	Касание к оружию
=================================================================================*/
public TouchWeapon(weapon, id)
{
	if(!is_user_connected(id))
	{
		return HAM_IGNORED
	}
	if(TouchWeapons[id] || cs_get_user_team(id) == CS_TEAM_T)
	{
		return HAM_SUPERCEDE
	}
	return HAM_IGNORED
}
/*================================================================================
	Использование комманд (отлов выстрела)
=================================================================================*/
public CmdStart(player, uc_handle, random_seed)
{
	if(!is_user_alive(player) || player < 1 || player > 32)
	{
		return FMRES_IGNORED
	}
	new Buttons = get_uc(uc_handle, UC_Buttons)
	if(Buttons & IN_ATTACK && Used[player])
	{
		if(Famas[player] && get_user_weapon(player, _, _) == CSW_FAMAS)
		{
			new wEnt = fm_find_ent_by_owner(-1, "weapon_famas", player);
			cs_set_weapon_burst(wEnt, 1)
		}
		if(!NotYou[player])
		{
			if(player == RussianRouletteID && DoIt[player])
			{	
				new id = player
				get_user_name(id, RussianRouletteName, 63)
				set_hudmessage(255, 255, 0, -1.0, 0.3, 0, 1.0, 2.0, 0.5, 0.5, 2)
				ShowSyncHudMsg(0, g_MsgHud2, "%L", LANG_PLAYER, "RRDOING", RussianRouletteName)
				set_task(3.0, "RussianRouletteStop", id)
				DoIt[id] = false
				Start[id] = true
			}
			else if(player == RussianRouletteID && Start[player])
			{
				client_print(player, print_center, "%L", LANG_PLAYER, "RRWAIT")
			}
			else
			{
				client_print(player, print_center, "%L", LANG_PLAYER, "RRNOTYOU")
			}
		}
		else if(Boom[player])
		{
			get_user_name(player, RussianRouletteName, 63)
			set_hudmessage(255, 0, 0, -1.0, 0.2, 1, 1.0, 5.0, 1.0, 1.0, 4)
			ShowSyncHudMsg(0, g_MsgHud3, "%L", LANG_PLAYER, "RRBOOM", RussianRouletteName)
			client_cmd(0, "spk weapons/deagle-1")
			set_msg_block(get_user_msgid("DeathMsg"), BLOCK_ONCE)
			DeathMsg(player, player, KHS, KWPN)
			Kill(player)
			Used[CounterID] = false
			Used[TerroristID] = false
		}
		else if(!Boom[player])
		{
			if(player == CounterID)
			{
				get_user_name(TerroristID, RussianRouletteName, 63)
				RussianRouletteMenu(TerroristID)
				NotYou[player] = false
				DoIt[TerroristID] = true
				RussianRouletteID = TerroristID
			}
			else if(player == TerroristID)
			{
				get_user_name(CounterID, RussianRouletteName, 63)
				RussianRouletteMenu(CounterID)
				NotYou[player] = false
				DoIt[CounterID] = true
				RussianRouletteID = CounterID
			}
			set_hudmessage(0, 255, 0, -1.0, 0.2, 0, 1.0, 3.0, 0.5, 0.5, 4)
			ShowSyncHudMsg(0, g_MsgHud3, "%L", LANG_PLAYER, "RRNOTBOOM", RussianRouletteName)
			client_cmd(0, "spk weapons/dryfire_pistol")
		}
		Buttons &= ~IN_ATTACK
		set_uc(uc_handle, UC_Buttons, Buttons)
	}
	if(Deagle[player])
	{
		cs_set_user_bpammo(player, CSW_DEAGLE, 1)
	}
	if(Scout[player])
	{
		cs_set_user_bpammo(player, CSW_SCOUT, 1)
	}
	if(Drob[player])
	{
		cs_set_user_bpammo(player, CSW_M3, 1)
	}
	if(Awp[player])
	{
		cs_set_user_bpammo(player, CSW_AWP, 1)
	}
	if(Famas[player] && get_user_weapon(player, _, _) == CSW_FAMAS)
	{
		new wEnt = fm_find_ent_by_owner(-1, "weapon_famas", player)
		if(wEnt)
		{
			cs_set_weapon_burst(wEnt, 1)
			cs_set_user_bpammo(player, CSW_FAMAS, 3)
		}
	}
	return FMRES_HANDLED
}
/*================================================================================
	Обновление данных о игроке
=================================================================================*/
public UpdateClientData(id, sendweapons, cd_handle)
{
	if(!is_user_alive(id))
	{
		return FMRES_IGNORED
	}
	if(Used[id] && InDuel[id])
	{
		set_cd(cd_handle, CD_ID, 0)
	}
	return FMRES_HANDLED
}
/*================================================================================
	Смерть игрока
=================================================================================*/
public PlayerKilled(victim, attacker, shouldgib)
{
	if(victim <= 0 || attacker <= 0 || victim >= 33 || attacker >= 33)
	{
		return PLUGIN_HANDLED
	}
	if(Duel)
	{
		if(cs_get_user_team(victim) == CS_TEAM_CT && InDuel[victim])
		{
			if(RussianRoulette[victim] || Math[victim] || Word[victim])
			{
				if(victim == CounterID)
				{
					attacker = TerroristID
				}
				else if(victim == TerroristID)
				{
					attacker = CounterID
				}
				TouchWeapons[attacker] = false
				Once[attacker] = false
				Knife[attacker] = false
				Deagle[attacker] = false
				Grenade[attacker] = false
				Scout[attacker] = false
				Drob[attacker] = false
				Awp[attacker] = false
				Math[attacker] = false
				Word[attacker] = false
				RussianRoulette[attacker] = false
				Used[attacker] = false
				NotYou[attacker] = false
				DoIt[attacker] = false
				Start[attacker] = false
				Spray[attacker] = false
				Guntoss[attacker] = false
				InDuel[attacker] = false
				Famas[attacker] = false
				Duel = false
			}
		}
	}
	remove_task(attacker)
	remove_task(victim)
	return PLUGIN_CONTINUE
}
/*================================================================================
	Команда открытия меню дуэлей
=================================================================================*/
public CmdDuelsMenu(id)
{
	if(!is_user_alive(id))
	{
		return PLUGIN_HANDLED
	}
	if (!Once[id])
	{
		if(cs_get_user_team(id) == CS_TEAM_CT)
		{
			new CTsNum = GetCTsNum(1)
			new TsNum = GetTsNum(1)
			if(CTsNum == 1 && TsNum >= 1)
			{
				DuelsMenu(id, MenuPosition[id] = 0)
			}
			else if(TsNum < 1)
			{
				ChatColor(id, "%s %L", PREFIX, LANG_PLAYER,"NOT_TS")
			}
			else if(CTsNum > 1)
			{
				ChatColor(id, "%s %L", PREFIX, LANG_PLAYER,"ONLY_LAST")
			}
		}
		else
		{
			ChatColor(id, "%s %L", PREFIX, LANG_PLAYER, "ONLY_CTS")
		}
	}
	return PLUGIN_HANDLED
}

/*================================================================================
	Меню дуэлей
=================================================================================*/
public DuelsMenu(id, position)
{
	if(position < 0)
	{
		return
	}
	FPage = false
	new DuelsNum = GetFlagsNum(PcvarDuels)
	new Flags = GetFlags(PcvarDuels)
	new MenuStart = position * 8
	if(MenuStart >= DuelsNum)
	{
		MenuStart = position = MenuPosition[id]
	}
	new MenuEnd = position * 8 + 8
	if(MenuEnd >= DuelsNum && position != 0)
	{
		MenuEnd = DuelsNum
	}
	else if(MenuEnd >= DuelsNum && position == 0)
	{
		MenuEnd = DCOUNT
		FPage = true
	}
	new Keys = MENU_KEY_0
	new Len
	new b
	Len = format(MenuBody, MENUBODY - 1, "\y%L^n^n", LANG_PLAYER, "CHOOSE_DUEL")
	for(new a = MenuStart; a < MenuEnd; a++)
	{
		if(Flags & (1 << a))
		{
			Keys |= (1 << b)
			Len += format(MenuBody[Len], MENUBODY - Len, "\r%d. \w%L^n", ++b, LANG_PLAYER, Duels[a])
		}
		else
		{
			continue
		}
	}
	if(MenuEnd != DuelsNum && !FPage)
	{
		Keys |= MENU_KEY_9
		Len += format(MenuBody[Len], MENUBODY - Len, "^n\r9. \w%L^n\r0. \w%L^n^n\y%s v%s by %s^nSpecial for LaFA", LANG_PLAYER, "DD_MENU_MORE", LANG_PLAYER, position ? "DD_MENU_BACK" : "DD_MENU_EXIT", PLUGIN, VERSION, AUTHOR)
	}
	else
	{
		Len += format(MenuBody[Len], MENUBODY - Len, "^n\r0. \w%L^n^n\y%s v%s by %s^nSpecial for LaFA", LANG_PLAYER, position ? "DD_MENU_BACK" : "DD_MENU_EXIT", PLUGIN, VERSION, AUTHOR)
	}
	show_menu(id, Keys, MenuBody, -1, "Duels Menu")
}
/*================================================================================
	Действие меню дуэлей
=================================================================================*/
public ActionDuelsMenu(id, key)
{
	switch(key)
	{
		case 8:
		{
			DuelsMenu(id, ++MenuPosition[id])
		}
		case 9:
		{
			DuelsMenu(id, --MenuPosition[id])
		}
		default:
		{
			if(GetTsNum(1) || GetCTsNum(1) == 1|| is_user_alive(id))
			{
				ChoosedDuel = MenuPosition[id] * 8 + key
				EnemyMenu(id, MenuPosition[id] = 0)
			}
		}
	}	
}
/*================================================================================
	Меню выбора противника
=================================================================================*/
public EnemyMenu(id, position)
{
	if(position < 0)
	{
		return
	}
	new TsNum = 0
	for(new aid = 1; aid <= MaxPlayers; aid++)
	{
		if(is_user_connected(aid) && is_user_alive(aid) && cs_get_user_team(aid) == CS_TEAM_T && !is_user_bot(aid))
		{
			MenuTs[TsNum++] = aid
		}
	}
	new MenuStart = position * 8
	if(MenuStart >= TsNum)
	{
		MenuStart = position = MenuPosition[id]
	}
	new MenuEnd = position + 8
	if(MenuEnd > TsNum)
	{
		MenuEnd = TsNum
	}
	new Keys = MENU_KEY_0
	new Len
	new b = 0
	new Names[32]
	Len = format(MenuBody, MENUBODY - 1, "\y%L^n^n", LANG_PLAYER, "CHOOSE_ENEMY")
	for(new a = MenuStart; a < MenuEnd; a++)
	{
		get_user_name(MenuTs[a], Names, 31)
		Keys |= (1 << b)
		Len += format(MenuBody[Len], MENUBODY - Len, "\r%d. \w%s^n", ++b, Names)
	}
	if(MenuEnd != TsNum)
	{
		Keys |= MENU_KEY_9
		Len += format(MenuBody[Len], MENUBODY - Len, "^n\r9. \w%L^n\r0. \w%L^n^n\y%s v%s by %s^nSpecial for LaFA", LANG_PLAYER, "DD_MENU_MORE", LANG_PLAYER, position ? "DD_MENU_BACK" : "DD_MENU_EXIT", PLUGIN, VERSION, AUTHOR)
	}
	else
	{
		Len += format(MenuBody[Len], MENUBODY - Len, "^n\r0. \w%L^n^n\y%s v%s by %s^nSpecial for LaFA", LANG_PLAYER, position ? "DD_MENU_BACK" : "DD_MENU_EXIT", PLUGIN, VERSION, AUTHOR)
	}
	show_menu(id, Keys, MenuBody, -1, "Enemy Menu")
}
/*================================================================================
	Действие выбора противника
=================================================================================*/
public ActionEnemyMenu(id, key)
{
	switch(key)
	{
		case 8:
		{
			EnemyMenu(id, ++MenuPosition[id])
		}
		case 9:
		{
			EnemyMenu(id, --MenuPosition[id])
		}
		default:
		{
			if(GetTsNum(1) || GetCTsNum(1) == 1 || is_user_alive(id))
			{
				new Choosed = MenuPosition[id] * 8 + key
				new Enemy = MenuTs[Choosed]
				StartDuel(id, Enemy)
			}
		}
	}	
}

public CmdOriginsMenu(id, level, cid)
{
	if(!cmd_access(id, level, cid, 1))
	{
		return PLUGIN_HANDLED
	}
	else
	{
		ShowOriginsMenu(id)
	}
	return PLUGIN_CONTINUE
}

public ShowOriginsMenu(id)
{
	new Keys = MENU_KEY_0
	new Len
	Len = format(MenuBody, MENUBODY, "\y%L^n^n", id, "ORIGINS_TITLE")
	Keys |= (1 << 0)
	Len += format(MenuBody[Len], MENUBODY - Len, "\r1. \w%L^n", id, "SAVE_POSITION")
	Keys |= (1 << 1)
	Len += format(MenuBody[Len], MENUBODY - Len, "\r2. \w%L^n", id, "DELETE_POSITIONS")
	Len += format(MenuBody[Len], MENUBODY - Len, "^n\r0. \w%L^n^n\y%s v%s by %s^nSpecial for LaFA", id, "DD_MENU_EXIT", PLUGIN, VERSION, AUTHOR)
	show_menu(id, Keys, MenuBody, -1, "Origins Menu")
	return PLUGIN_CONTINUE
}

public ActionOriginsMenu(id, key)
{
	switch(key)
	{
		case 0:
		{
			new  vec[3]
			get_user_origin(id, vec)
			add_spawn(vec)
			client_print(id, print_center, "*** Saved ***")
			ShowOriginsMenu(id)
		}
		case 1:
		{
			if(file_exists(OriginsFile))
			{
				delete_file(OriginsFile)
				client_print(id, print_center, "*** Deleted ***")
				ShowOriginsMenu(id)
			}
		}
	}
	return PLUGIN_CONTINUE
}

public add_spawn(vecs[3])
{
	new Line[128]
	format(Line, 127, "%d %d %d",vecs[0], vecs[1], vecs[2])
	write_file(OriginsFile, Line)
	return PLUGIN_CONTINUE
}

public SetOrigins(ctid, terid)
{
	if(!file_exists(OriginsFile) || !get_pcvar_num(PcvarTele))
	{
		return PLUGIN_CONTINUE
	}
	new pos[4][8]
	parse(Origins[0], pos[1], 7, pos[2], 7, pos[3], 7)
	new Vec[3]
	Vec[0] = str_to_num(pos[1])
	Vec[1] = str_to_num(pos[2])
	Vec[2] = str_to_num(pos[3])
	set_user_origin(ctid, Vec)
	parse(Origins[1], pos[1], 7, pos[2], 7, pos[3], 7)
	Vec[0] = str_to_num(pos[1])
	Vec[1] = str_to_num(pos[2])
	Vec[2] = str_to_num(pos[3])
	set_user_origin(terid, Vec)
	return PLUGIN_CONTINUE
}
/*================================================================================
	Начало дуэли
=================================================================================*/
public StartDuel(id, tempid)
{
	if(!GetTsNum(1) || GetCTsNum(1) > 1|| !is_user_alive(tempid) || !is_user_alive(id) || cs_get_user_team(tempid) != CS_TEAM_T || cs_get_user_team(id) != CS_TEAM_CT || !is_user_connected(tempid) || !is_user_connected(id) || is_user_bot(id) || is_user_bot(tempid))
	{
		return PLUGIN_HANDLED
	}
	new challenger[32], challenged[32]
	get_user_name(id, challenger, 31)
	get_user_name(tempid, challenged, 31)
	strip_user_weapons(id)
	strip_user_weapons(tempid)
	set_user_health(id, 100)
	set_user_health(tempid, 100)
	switch(get_pcvar_num(PcvarEffects))
	{
		case 1:
		{
			set_user_rendering(id, kRenderFxGlowShell, 0, 0, 150, kRenderNormal, 20)	
			set_user_rendering(tempid, kRenderFxGlowShell, 150, 0, 0, kRenderNormal, 20)
		}
		case 2:
		{
			set_task(1.0, "Beacon", id)
			set_task(1.0, "Beacon", tempid)
		}
		case 3:
		{
			set_user_rendering(id, kRenderFxGlowShell, 0, 0, 150, kRenderNormal, 20)	
			set_task(1.0, "Beacon", id)
			set_user_rendering(tempid, kRenderFxGlowShell, 150, 0, 0, kRenderNormal, 20)
			set_task(1.0, "Beacon", tempid)
		}
	}
	InDuel[tempid] = true
	InDuel[id] = true
	Once[id] = true 
	TouchWeapons[id] = true
	TouchWeapons[tempid] = true
	CounterID = id
	TerroristID = tempid
	Timer = get_pcvar_num(PcvarWait)
	Index = get_pcvar_num(PcvarTimeLimit) + 1
	set_pcvar_string(PcvarMode, "DUEL")
	new Flags = GetFlags(PcvarDuels)
	DuelNum = 0
	new DuelIndex
	while(DuelIndex <= ChoosedDuel)
	{
		if(Flags & (1 << DuelNum))
		{
			DuelIndex++
		}
		DuelNum ++
	}
	SetOrigins(id, tempid)
	switch(DuelNum)
	{
		case 1:
		{
			Knife[id] = true
			Knife[tempid] = true
			Duel = true
			ChatColor(0, "%s %L", PREFIX, LANG_PLAYER,"KNIFE1",  challenger, challenged) 	
			set_task(0.0, "StartWait", WAITTIMERTID)
			return PLUGIN_HANDLED
		}
		case 2:
		{
			Deagle[id] = true
			Deagle[tempid] = true
			Duel = true
			ChatColor(0, "%s %L", PREFIX, LANG_PLAYER,"DEAGLE1", challenger, challenged) 
			ChatColor(0, "%s %L", PREFIX, LANG_PLAYER,"DEAGLE2")
			set_task(0.0, "StartWait", WAITTIMERTID)
			return PLUGIN_HANDLED 
		}
		case 3:
		{
			Grenade[id] = true
			Grenade[tempid] = true
			Duel = true
			ChatColor(0, "%s %L", PREFIX, LANG_PLAYER,"GRENADE1", challenger, challenged) 
			ChatColor(0, "%s %L", PREFIX, LANG_PLAYER,"GRENADE2") 
			set_task(0.0, "StartWait", WAITTIMERTID)
			return PLUGIN_HANDLED
		}
		case 4:
		{
			Scout[id] = true
			Scout[tempid] = true
			Duel = true
			ChatColor(0, "%s %L", PREFIX, LANG_PLAYER,"SCOUT1", challenger, challenged) 
			ChatColor(0, "%s %L", PREFIX, LANG_PLAYER,"SCOUT2") 
			set_task(0.0, "StartWait", WAITTIMERTID)
			return PLUGIN_HANDLED
		}
		case 5:
		{
			Drob[id] = true
			Drob[tempid] = true
			Duel = true
			ChatColor(0, "%s %L", PREFIX, LANG_PLAYER,"DROB1", challenger, challenged) 
			ChatColor(0, "%s %L", PREFIX, LANG_PLAYER,"DROB2") 
			set_task(0.0, "StartWait", WAITTIMERTID)
			return PLUGIN_HANDLED
		}
		case 6:
		{
			Awp[id] = true
			Awp[tempid] = true
			Duel = true
			ChatColor(0, "%s %L", PREFIX, LANG_PLAYER,"AWP1", challenger, challenged) 
			ChatColor(0, "%s %L", PREFIX, LANG_PLAYER,"AWP2") 
			set_task(0.0, "StartWait", WAITTIMERTID)
			return PLUGIN_HANDLED
		}
		case 7:
		{
			Famas[id] = true
			Famas[tempid] = true
			Duel = true
			ChatColor(0, "%s %L", PREFIX, LANG_PLAYER, "FAMAS1", challenger, challenged)
			ChatColor(0, "%s %L", PREFIX, LANG_PLAYER, "FAMAS2")
			set_task(0.0, "StartWait", WAITTIMERTID)
			return PLUGIN_HANDLED
		}
		case 8:
		{
			RussianRoulette[id] = true
			RussianRoulette[tempid] = true
			Duel = true
			RussianRouletteBullet = random_num(1, 3)
			cs_set_weapon_ammo(give_item(id, "weapon_deagle"), RussianRouletteBullet)
			cs_set_weapon_ammo(give_item(tempid, "weapon_deagle"), RussianRouletteBullet)
			StartRussianRoulette(id, tempid)
			if(get_pcvar_num(PcvarMusic))
			{
				new musicnum = random_num(0, MCOUNT-1)
				client_cmd(0, "mp3volume 0.5")
				client_cmd(0, "mp3 play %s", Music[musicnum])
			}
			return PLUGIN_HANDLED
		}
		case 9:
		{
			Math[id] = true
			Math[tempid] = true
			Duel = true
			StartMathDuel(id, tempid)
			return PLUGIN_HANDLED
		}
		case 10:
		{
			Word[id] = true
			Word[tempid] = true
			Duel = true
			StartWordDuel(id, tempid)
			return PLUGIN_HANDLED
		}
		case 11:
		{
			Spray[id] = true
			Spray[tempid] = true
			Duel = true
			give_item(id, "weapon_knife")	
			give_item(tempid, "weapon_knife")
			ChatColor(0, "%s %L", PREFIX, LANG_PLAYER,"SPRAY1", challenger, challenged) 
			ChatColor(0, "%s %L", PREFIX, LANG_PLAYER,"SPRAY2") 
			ChatColor(0, "%s %L", PREFIX, LANG_PLAYER,"SPRAY3", challenger) 
		}
		case 12:
		{
			Guntoss[id] = true
			Guntoss[tempid] = true
			Duel = true
			give_item(id, "weapon_knife")	
			give_item(tempid, "weapon_knife")
			cs_set_weapon_ammo(give_item(id, "weapon_deagle"), 0)
			cs_set_weapon_ammo(give_item(tempid, "weapon_deagle"), 0)
			ChatColor(0, "%s %L", PREFIX, LANG_PLAYER,"GUNTOSS1", challenger, challenged) 
			ChatColor(0, "%s %L", PREFIX, LANG_PLAYER,"GUNTOSS2") 
			ChatColor(0, "%s %L", PREFIX, LANG_PLAYER,"GUNTOSS3", challenger) 
		}
	}
	if(get_pcvar_num(PcvarMusic))
	{
		new musicnum = random_num(0, MCOUNT-1)
		client_cmd(0, "mp3volume 0.5")
		client_cmd(0, "mp3 play %s", Music[musicnum])
	}
	if(get_pcvar_num(PcvarTimer))
	{
		set_task(0.0, "DuelTimer", TIMERTID)
	}
	Duel = true
	return PLUGIN_HANDLED
}
/*================================================================================
	Таймер
=================================================================================*/
public DuelTimer()
{
	Index--
	if(Index > 60)
	{
		set_hudmessage(255, 255, 255, -1.0, 0.25, 0, 1.0, 1.0, _, _, 2)
		if(Math[CounterID])
		{
			ShowSyncHudMsg(0, g_MsgHud2, "%L", LANG_PLAYER, "DUEL_TIMER2", Index, MathTask)
		}
		else if(Word[CounterID])
		{
			ShowSyncHudMsg(0, g_MsgHud2, "%L", LANG_PLAYER, "DUEL_TIMER2", Index, WordAnswer)
		}
		else 
		{
			ShowSyncHudMsg(0, g_MsgHud2, "%L", LANG_PLAYER, "DUEL_TIMER", Index)
		}
		set_task(1.0, "DuelTimer", TIMERTID)
	}
	else if(60 >= Index >= 46)
	{
		set_hudmessage(0, 255, 0, -1.0, 0.25, 0, 1.0, 1.0, _, _, 2)
		if(Math[CounterID])
		{
			ShowSyncHudMsg(0, g_MsgHud2, "%L", LANG_PLAYER, "DUEL_TIMER2", Index, MathTask)
		}
		else if(Word[CounterID])
		{
			ShowSyncHudMsg(0, g_MsgHud2, "%L", LANG_PLAYER, "DUEL_TIMER2", Index, WordAnswer)
		}
		else 
		{
			ShowSyncHudMsg(0, g_MsgHud2, "%L", LANG_PLAYER, "DUEL_TIMER", Index)
		}
		set_task(1.0, "DuelTimer", TIMERTID)
	}
	else if(45 >= Index >= 31)
	{
		set_hudmessage(255, 255, 0, -1.0, 0.25, 0, 1.0, 1.0, _, _, 2)
		if(Math[CounterID])
		{
			ShowSyncHudMsg(0, g_MsgHud2, "%L", LANG_PLAYER, "DUEL_TIMER2", Index, MathTask)
		}
		else if(Word[CounterID])
		{
			ShowSyncHudMsg(0, g_MsgHud2, "%L", LANG_PLAYER, "DUEL_TIMER2", Index, WordAnswer)
		}
		else 
		{
			ShowSyncHudMsg(0, g_MsgHud2, "%L", LANG_PLAYER, "DUEL_TIMER", Index)
		}
		set_task(1.0, "DuelTimer", TIMERTID)
	}
	else if(30 >= Index >= 16)
	{
		set_hudmessage(255, 0, 0, -1.0, 0.25, 0, 1.0, 1.0, _, _, 2)
		if(Math[CounterID])
		{
			ShowSyncHudMsg(0, g_MsgHud2, "%L", LANG_PLAYER, "DUEL_TIMER2", Index, MathTask)
		}
		else if(Word[CounterID])
		{
			ShowSyncHudMsg(0, g_MsgHud2, "%L", LANG_PLAYER, "DUEL_TIMER2", Index, WordAnswer)
		}
		else 
		{
			ShowSyncHudMsg(0, g_MsgHud2, "%L", LANG_PLAYER, "DUEL_TIMER", Index)
		}
		set_task(1.0, "DuelTimer", TIMERTID)
	}
	else if(Index <= 15)
	{
		set_hudmessage(255, 0, 0, -1.0, 0.25, 1, 1.0, 1.0, _, _, 2)
		if(Index > 0)
		{
			if(Math[CounterID])
			{
				ShowSyncHudMsg(0, g_MsgHud2, "%L", LANG_PLAYER, "DUEL_TIMER2", Index, MathTask)
			}
			else if(Word[CounterID])
			{
				ShowSyncHudMsg(0, g_MsgHud2, "%L", LANG_PLAYER, "DUEL_TIMER2", Index, WordAnswer)
			}
			else 
			{
				ShowSyncHudMsg(0, g_MsgHud2, "%L", LANG_PLAYER, "DUEL_TIMER", Index)
			}
		}
		else if(Index < 0)
		{
			ShowSyncHudMsg(0, g_MsgHud2, "%L", LANG_PLAYER, "NO_WINNER")
			Kill(CounterID)
			Kill(TerroristID)
			remove_task(TIMERTID)
			if(get_pcvar_num(PcvarMusic))
			{
				client_cmd(0, "cd fadeout")
			}
		}
		set_task(1.0, "DuelTimer", TIMERTID)
	}
	if(!is_user_alive(CounterID) || !is_user_alive(TerroristID))
	{
		remove_task(TIMERTID)
		if(get_pcvar_num(PcvarMusic))
		{
			client_cmd(0, "cd fadeout")
		}
	}
	return PLUGIN_CONTINUE
}

public DuelTimer2()
{
	set_hudmessage(255, 255, 255, -1.0, 0.25, 0, 1.0, 1.0, _, _, 2)
	if(Math[CounterID])
	{
		ShowSyncHudMsg(0, g_MsgHud2, "%L", LANG_PLAYER, "DUELTASK", MathTask)
	}
	if(Word[TerroristID])
	{
		ShowSyncHudMsg(0, g_MsgHud2, "%L", LANG_PLAYER, "DUELTASK", WordAnswer)
	}
	set_task(1.0, "DuelTimer2", TIMER2TID)
	if(!is_user_alive(CounterID) || !is_user_alive(TerroristID))
	{
		remove_task(TIMER2TID)
		if(get_pcvar_num(PcvarMusic))
		{
			client_cmd(0, "cd fadeout")
		}
	}
}
/*================================================================================
	Математическая дуэль
=================================================================================*/
public StartMathDuel(ct, ter)
{
	new num1,num2,num3,num4,mode, ctname[64], tername[64]
	mode = random_num(0, 6)
	num1 = random_num(1, 100)
	num2 = random_num(1, 10)
	num3 = random_num(1, 100)
	num4 = random_num(1, 10)
	get_user_name(ct, ctname, 63)
	get_user_name(ter, tername, 63)
	switch(mode)
	{
		case 0:
		{
			format(MathTask, 63, "%d + %d + %d + %d = ?", num1, num2, num3, num4)
			MathAnswer = num1 + num2 + num3 + num4
		}
		case 1:
		{
			format(MathTask, 63, "%d + %d + %d - %d = ?", num1,num2,num3,num4)
			MathAnswer = num1 + num2 + num3 - num4
		}
		case 2:
		{
			format(MathTask, 63, "%d + %d - %d + %d = ?", num1, num2, num3, num4)
			MathAnswer = num1 + num2 - num3 + num4
		}
		case 3:
		{
			format(MathTask, 63, "%d - %d + %d + %d = ?", num1, num2, num3, num4)
			MathAnswer = num1 - num2 + num3 + num4
		}
		case 4:
		{
			format(MathTask, 63, "%d + %d - %d - %d = ?", num1, num2, num3, num4)
			MathAnswer = num1 + num2 - num3 - num4
		}
		case 5:
		{
			format(MathTask, 63, "%d - %d + %d - %d = ?", num1, num2, num3, num4)
			MathAnswer = num1 - num2 + num3 - num4
		}
		case 6:
		{
			format(MathTask, 63, "%d - %d - %d + %d = ?", num1, num2, num3, num4)
			MathAnswer = num1 - num2 - num3 + num4
		}
	}
	ChatColor(0, "%s %L", PREFIX, LANG_PLAYER, "MATH1", ctname, tername)
	ChatColor(0, "%s %L", PREFIX, LANG_PLAYER, "MATH2")
	set_task(0.0, "StartWait", WAITTIMERTID)
	return PLUGIN_CONTINUE
}
/*================================================================================
	Словесная дуэль
=================================================================================*/
public StartWordDuel(ct, ter)
{
	new ctname[64], tername[64]
	format(WordAnswer, charsmax(WordAnswer), "%s", Words[random_num(0, WordsNum)])
	get_user_name(ct, ctname, 63)
	get_user_name(ter, tername, 63)
	ChatColor(0, "%s %L", PREFIX, LANG_PLAYER, "WORD1", ctname, tername)
	ChatColor(0, "%s %L", PREFIX, LANG_PLAYER, "WORD2")
	set_task(0.0, "StartWait", WAITTIMERTID)
	return PLUGIN_CONTINUE
}
/*================================================================================
	Ожидание дуэли
=================================================================================*/
public StartWait()
{
	set_hudmessage(255, 255, 255, -1.0, 0.25, 0, 1.0, 1.0, _, _, 2)
	switch(DuelNum)
	{
		case 1:
		{
			ShowSyncHudMsg(0, g_MsgHud2, "%L^n%L", LANG_PLAYER, "KNIFE_WAIT", LANG_PLAYER, "STARTAFTER", Timer)
		}
		case 2:
		{
			ShowSyncHudMsg(0, g_MsgHud2, "%L^n%L", LANG_PLAYER, "DEAGLE_WAIT", LANG_PLAYER, "STARTAFTER", Timer)
		}
		case 3:
		{
			ShowSyncHudMsg(0, g_MsgHud2, "%L^n%L", LANG_PLAYER, "GRENADE_WAIT", LANG_PLAYER, "STARTAFTER", Timer)
		}
		case 4:
		{
			ShowSyncHudMsg(0, g_MsgHud2, "%L^n%L", LANG_PLAYER, "SCOUT_WAIT", LANG_PLAYER, "STARTAFTER", Timer)
		}
		case 5:
		{
			ShowSyncHudMsg(0, g_MsgHud2, "%L^n%L", LANG_PLAYER, "DROB_WAIT", LANG_PLAYER, "STARTAFTER", Timer)
		}
		case 6:
		{
			ShowSyncHudMsg(0, g_MsgHud2, "%L^n%L", LANG_PLAYER, "AWP_WAIT", LANG_PLAYER, "STARTAFTER", Timer)
		}
		case 7:
		{
			ShowSyncHudMsg(0, g_MsgHud2, "%L^n%L", LANG_PLAYER, "FAMAS_WAIT", LANG_PLAYER, "STARTAFTER", Timer)
		}
		case 9:
		{
			ShowSyncHudMsg(0, g_MsgHud2, "%L^n%L", LANG_PLAYER, "MATH_WAIT", LANG_PLAYER, "STARTAFTER", Timer)
		}
		case 10:
		{
			ShowSyncHudMsg(0, g_MsgHud2, "%L^n%L", LANG_PLAYER, "WORD_WAIT", LANG_PLAYER, "STARTAFTER", Timer)
		}
	}
	Timer--
	client_cmd(0, "spk %s", Sound[Timer])
	if(Timer <= 0)
	{
		set_task(1.0, "StartGo")
	}
	else
	{
		
		set_task(1.0, "StartWait", WAITTIMERTID)
	}
	return PLUGIN_CONTINUE
}
/*================================================================================
	Дуэль началась
=================================================================================*/
public StartGo()
{
	if(!is_user_alive(TerroristID) || !is_user_alive(CounterID) || !is_user_connected(TerroristID) || !is_user_connected(CounterID) || !is_valid_player(CounterID) || !is_valid_player(TerroristID))
	{
		return PLUGIN_HANDLED
	}
	switch(DuelNum)
	{
		case 1:
		{
			give_item(CounterID, "weapon_knife")
			give_item(TerroristID, "weapon_knife")	
		}
		case 2:
		{
			cs_set_weapon_ammo(give_item(CounterID, "weapon_deagle"), DAMMO)
			cs_set_weapon_ammo(give_item(TerroristID, "weapon_deagle"), DAMMO)
		}
		case 3:
		{
			give_item(CounterID, "weapon_hegrenade")
			give_item(TerroristID, "weapon_hegrenade")
			cs_set_user_bpammo(CounterID, CSW_HEGRENADE, 100)		
			cs_set_user_bpammo(TerroristID, CSW_HEGRENADE, 100)
		}
		case 4:
		{
			cs_set_weapon_ammo(give_item(CounterID, "weapon_scout"), DAMMO)
			cs_set_weapon_ammo(give_item(TerroristID, "weapon_scout"), DAMMO)
		}
		case 5:
		{
			cs_set_weapon_ammo(give_item(CounterID, "weapon_m3"), 8)
			cs_set_weapon_ammo(give_item(TerroristID, "weapon_m3"), 8)
		}
		case 6:
		{
			cs_set_weapon_ammo(give_item(CounterID, "weapon_awp"), DAMMO)
			cs_set_weapon_ammo(give_item(TerroristID, "weapon_awp"), DAMMO)
		}
		case 7:
		{
			cs_set_weapon_ammo(give_item(CounterID, "weapon_famas"), 3)
			new wEnt = fm_find_ent_by_owner(-1, "weapon_famas", CounterID)
			if(wEnt)
			{
				cs_set_weapon_burst(wEnt, 1)
			}
			cs_set_weapon_ammo(give_item(TerroristID, "weapon_famas"), 3)
			wEnt = fm_find_ent_by_owner(-1, "weapon_famas", TerroristID)
			if(wEnt)
			{
				cs_set_weapon_burst(wEnt, 1)
			}
		}
	}
	if(get_pcvar_num(PcvarMusic))
	{
		new musicnum = random_num(0, MCOUNT-1)
		client_cmd(0, "mp3volume 0.5")
		client_cmd(0, "mp3 play %s", Music[musicnum])
	}
	if(get_pcvar_num(PcvarTimer))
	{
		set_task(0.0, "DuelTimer", TIMERTID)
	}
	else if(Math[CounterID] || Word[CounterID])
	{
		set_task(0.0, "DuelTimer2", TIMER2TID)
	}
	return PLUGIN_CONTINUE
}
/*================================================================================
	Старт русской рулетки
=================================================================================*/
public StartRussianRoulette(ct, ter)
{
	new ctname[64], tername[64]
	get_user_name(ct, ctname, 63)
	get_user_name(ter, tername, 63)
	ChatColor(0, "%s %L", PREFIX, LANG_PLAYER, "RR1", ctname, tername)
	ChatColor(0, "%s %L", PREFIX, LANG_PLAYER, "RR2")
	ChatColor(0, "%s %L", PREFIX, LANG_PLAYER, "RR3", ctname)
	set_hudmessage(0, 255, 0, -1.0, 0.2, 0, 1.0, 2.0, 0.5, 0.5, 4)
	ShowSyncHudMsg(0, g_MsgHud3, "%L", LANG_PLAYER, "RRSTART", ctname, RussianRouletteBullet)
	RussianRouletteMenu(ct)
	Used[ct] = true
	Used[ter] = true
	NotYou[ct] = false
	NotYou[ter] = false
	RussianRouletteID = ct
	return PLUGIN_CONTINUE
}
/*================================================================================
	Меню русской рулетки
=================================================================================*/
public RussianRouletteMenu(id)
{
	new Len
	new Keys = MENU_KEY_0
	Len = format(MenuBody, MENUBODY - 1, "\y%L\w^n^n", LANG_PLAYER, "RRTITLE")
	Keys |= (1 << 0)
	Len += format(MenuBody[Len], MENUBODY - Len, "\r1. \w%L^n^n\y%s v%s by %s^nSpecial for LaFA", LANG_PLAYER, "RRDO", PLUGIN, VERSION, AUTHOR)
	DoIt[id] = true
	show_menu(id, Keys, MenuBody, -1, "Roulette Menu")
	return PLUGIN_CONTINUE
}
/*================================================================================
	Запуск барабана
=================================================================================*/
public ActionRussianRouletteMenu(id, Key)
{
	if(!DoIt[id])
	{
		return PLUGIN_HANDLED
	}
	get_user_name(id, RussianRouletteName, 63)
	set_hudmessage(255, 255, 0, -1.0, 0.3, 0, 1.0, 2.0, 0.5, 0.5, 2)
	ShowSyncHudMsg(0, g_MsgHud2, "%L", LANG_PLAYER, "RRDOING", RussianRouletteName)
	set_task(3.0, "RussianRouletteStop", id)
	DoIt[id] = false
	Start[id] = true
	return PLUGIN_HANDLED
}
/*================================================================================
	Остановка барабана
=================================================================================*/
public RussianRouletteStop(id)
{
	new RuletteRandom
	RuletteRandom = random_num(1, 7)
	get_user_name(id, RussianRouletteName, 63)
	if(RussianRouletteBullet == 1 && RuletteRandom == 1)
	{
		Boom[id] = true
	}
	else if(RussianRouletteBullet == 2 && RuletteRandom == 2)
	{
		Boom[id] = true
	}
	else if(RussianRouletteBullet == 3 && RuletteRandom == 3)
	{
		Boom[id] = true
	}
	else
	{
		Boom[id] = false
	}
	NotYou[id] = true
	Start[id] = false
	set_hudmessage(255, 255, 0, -1.0, 0.3, 0, 1.0, 2.0, 0.5, 0.5, 2)
	ShowSyncHudMsg(0, g_MsgHud2, "%L", LANG_PLAYER, "RRPRESS", RussianRouletteName)
	return PLUGIN_CONTINUE
}
/*================================================================================
	Проверка ответа в общем чате
=================================================================================*/
public hooksay(id)
{
	if(!Math[id] && !Word[id])
	{
		return PLUGIN_CONTINUE
	}
	new Msg[256], smanswer[32], wname[32]
	read_args(Msg, 255)
	remove_quotes(Msg)
	num_to_str(MathAnswer, smanswer, 31)
	if((Math[id] && equal(Msg, smanswer)) || (Word[id] && equal(Msg, WordAnswer)))
	{
		if(get_pcvar_num(PcvarTimer))
		{
			remove_task(TIMERTID)
		}
		if(get_pcvar_num(PcvarMusic))
		{
			client_cmd(0, "cd fadeout")
		}
		get_user_name(id, wname, 31)
		//set_user_lifes(id, 1)
		set_hudmessage(0, 255, 0, -1.0, 0.2, 0, 1.0, 10.0, 1.0, 1.0, 2)
		if(Math[id])
		{
			ShowSyncHudMsg(0, g_MsgHud2, "%L", LANG_PLAYER, "MATH_WINNER", wname, smanswer)
		}
		else if(Word[id])
		{
			ShowSyncHudMsg(0, g_MsgHud2, "%L", LANG_PLAYER, "WORD_WINNER", wname)
		}
		if(id == CounterID)
		{
			set_msg_block(get_user_msgid("DeathMsg"), BLOCK_ONCE)
			DeathMsg(CounterID, TerroristID, 1, KWPN)
			Kill(TerroristID)
		}
		else if(id == TerroristID)
		{
			set_msg_block(get_user_msgid("DeathMsg"), BLOCK_ONCE)
			DeathMsg(CounterID, TerroristID, 1, KWPN)
			Kill(CounterID)
		}
		Math[CounterID] = false
		Math[TerroristID] = false
		Word[CounterID] = false
		Word[TerroristID] = false
	}
	return PLUGIN_CONTINUE
}
/*================================================================================
	Проверка ответа в командном чате
=================================================================================*/
public hooksay_team(id)
{
	if(!Math[id] && !Word[id])
	{
		return PLUGIN_CONTINUE
	}
	new Msg[256], smanswer[32], wname[32]
	read_args(Msg, 255)
	remove_quotes(Msg)
	num_to_str(MathAnswer, smanswer, 31)
	if((Math[id] && equal(Msg, smanswer)) || (Word[id] && equal(Msg, WordAnswer)))
	{
		if(get_pcvar_num(PcvarTimer))
		{
			remove_task(TIMERTID)
		}
		if(get_pcvar_num(PcvarMusic))
		{
			client_cmd(0, "cd fadeout")
		}
		get_user_name(id, wname, 31)
		//set_user_lifes(id, 1)
		set_hudmessage(0, 255, 0, -1.0, 0.2, 0, 1.0, 10.0, 1.0, 1.0, 2)
		if(Math[id])
		{
			ShowSyncHudMsg(0, g_MsgHud2, "%L", LANG_PLAYER, "MATH_WINNER", wname, smanswer)
		}
		else if(Word[id])
		{
			ShowSyncHudMsg(0, g_MsgHud2, "%L", LANG_PLAYER, "WORD_WINNER", wname)
		}
		if(id == CounterID)
		{
			set_msg_block(get_user_msgid("DeathMsg"), BLOCK_ONCE)
			DeathMsg(CounterID, TerroristID, 1, KWPN)
			Kill(TerroristID)
		}
		else if(id == TerroristID)
		{
			set_msg_block(get_user_msgid("DeathMsg"), BLOCK_ONCE)
			DeathMsg(CounterID, TerroristID, 1, KWPN)
			Kill(CounterID)
		}
		Math[CounterID] = false
		Math[TerroristID] = false
		Word[CounterID] = false
		Word[TerroristID] = false
	}
	return PLUGIN_CONTINUE
}
/*================================================================================
	Игрок покинул сервер
=================================================================================*/
public client_disconnect(id)
{
	remove_task(id)
	TouchWeapons[id] = false
	Once[id] = false
	Knife[id] = false
	Deagle[id] = false
	Grenade[id] = false
	Scout[id] = false
	Drob[id] = false
	Awp[id] = false
	Math[id] = false
	Word[id] = false
	RussianRoulette[id] = false
	Used[id] = false
	NotYou[id] = false
	DoIt[id] = false
	Start[id] = false
	Spray[id] = false
	Guntoss[id] = false
	InDuel[id] = false
	Famas[id] = false
	return PLUGIN_CONTINUE
}
/*================================================================================
	Выключение неуязвимости
=================================================================================*/
public GodOff(tskid)
{
	new id = tskid - GODTID
	set_pev(id, pev_takedamage, 1)
	return PLUGIN_CONTINUE
}
/*================================================================================
	Информер
=================================================================================*/
public Informer()
{
	if(!get_pcvar_num(PcvarInformer))
	{
		remove_task(INFORMERTID)
		return PLUGIN_HANDLED
	}
	new id, LastID, acts, cts, all, CurrentTime[32], NextMap[32], Terrorist[32], names[33][32], Message[512]
	for(id = 1; id <= MaxPlayers; id++)
	{
		if(!is_user_connected(id))
		{
			continue
		}
		else if(is_user_alive(id) && cs_get_user_team(id) == CS_TEAM_CT)
		{
			acts++
			cts++
			all ++
			LastID = id
			get_user_name(id, names[acts], 31)
		}
		else if(!is_user_alive(id) && cs_get_user_team(id) == CS_TEAM_CT)
		{
			cts++
			all++
		}
		else if(cs_get_user_team(id) == CS_TEAM_T && !is_user_bot(id))
		{
			get_user_name(id, Terrorist, 63)
			all++
		}
		else
		{
			all++
		}
	}
	if(acts == 1 && !Last && get_pcvar_num(PcvarLastMenu))
	{
		LastMenu(LastID)
		Last = true
	}
	for(id = 1; id <= MaxPlayers; id++)
	{
		new Len, Mode[32]
		get_pcvar_string(PcvarMode, Mode, 31)
		Len = format(Message, 511, "%L: %L", LANG_PLAYER, "CURRENTMODE", LANG_PLAYER, Mode)
		get_time("%H:%M:%S", CurrentTime, 31)
		Len += format(Message[Len], 511 - Len, "^n%L: %s", LANG_PLAYER, "CURRENTTIME", CurrentTime)
		if(get_cvar_float("mp_timelimit"))
		{
			new a = get_timeleft()
			Len += format(Message[Len], 511 - Len, "^n%L: %d:%02d", LANG_PLAYER, "TLEFT", (a / 60), (a % 60))
		}
		else
		{
			Len += format(Message[Len], 511 - Len, "^n%L: %L", LANG_PLAYER, "TLEFT", LANG_PLAYER, "LASTR")
		}
		get_cvar_string("amx_nextmap", NextMap, 31)
		Len += format(Message[Len], 511 - Len, "^n%L: %s", LANG_PLAYER, "NMAP", NextMap)
		if(GetTsNum(0))
		{
			Len += format(Message[Len], 511 - Len, "^n%L: %s", LANG_PLAYER, "CTER", Terrorist)
		}
		else
		{
			Len += format(Message[Len], 511 - Len, "^n%L: %L", LANG_PLAYER, "CTER", LANG_PLAYER, "TNONE")
		}
		Len += format(Message[Len], 511 - Len, "^n%L: %d/%d", LANG_PLAYER, "ALIVECTS", acts,cts)
		Len += format(Message[Len], 511 - Len, "^n%L: %d/%d", LANG_PLAYER, "APLAYERS", all, MaxPlayers)
		if(acts > 3)
		{
			set_hudmessage(100, 100, 100, 0.01, 0.18, 0, 1.0, 1.0)
		}
		else if(acts == 3)
		{
			set_hudmessage(0, 255, 0, 0.01, 0.18, 0, 1.0, 1.0)
			Len += format(Message[Len], 511 - Len, "^n^n1. %s^n2. %s^n3. %s", names[1], names[2], names[3])
		}
		else if(acts == 2)
		{
			set_hudmessage(255, 255, 0, 0.01, 0.18, 0, 1.0, 1.0)
			Len += format(Message[Len], 511 - Len, "^n^n1. %s^n2. %s", names[1], names[2])
		}
		else
		{
			set_hudmessage(255, 0, 0, 0.01, 0.18, 1, 1.0, 1.0, _, _, 1)
			Len += format(Message[Len], 511 - Len, "^n^n1. %s", names[1])
		}
		ShowSyncHudMsg(id, g_MsgHud1, "%s", Message)	
	}
	return PLUGIN_CONTINUE
}
/*================================================================================
	Меню последнего КТ
=================================================================================*/
public LastMenu(id)
{
	new Len
	new Keys = MENU_KEY_0
	Len = format(MenuBody, MENUBODY - 1, "\y%L\w^n^n", LANG_PLAYER, "YOULAST")
	Keys |= (1 << 0)
	Len += format(MenuBody[Len], MENUBODY - Len, "\r1. \w%L^n", LANG_PLAYER, "LASTYES")
	Keys |= (1 << 1)
	Len += format(MenuBody[Len], MENUBODY - Len, "\r2. \w%L^n^n\y%s v%s by %s^nSpecial for LaFA", LANG_PLAYER, "LASTNO", PLUGIN, VERSION, AUTHOR)
	show_menu(id, Keys, MenuBody, -1, "Last Menu")
	return PLUGIN_CONTINUE
}
/*================================================================================
	Действие меню последнего КТ
=================================================================================*/
public ActionLastMenu(id, key)
{
	switch(key)
	{
		case 0:
		{
			client_cmd(id, "deathrun_duels")
		}
		case 1:
		{
			client_print(id, print_center, "%L", LANG_PLAYER, "FDUEL")
		}
	}
	return PLUGIN_CONTINUE
}
/*================================================================================
	Эффект волны
=================================================================================*/
public Beacon(id)
{
	if(cs_get_user_team(id) == CS_TEAM_CT)
	{
		static origin[3]
		get_user_origin(id, origin)
		message_begin(MSG_BROADCAST, SVC_TEMPENTITY)
		write_byte(TE_BEAMCYLINDER)
		write_coord(origin[0])
		write_coord(origin[1])
		write_coord(origin[2]-20)	
		write_coord(origin[0]) 
		write_coord(origin[1]) 
		write_coord(origin[2]+200)
		write_short(BeaconSprite)
		write_byte(0)
		write_byte(1)
		write_byte(6)
		write_byte(2) 
		write_byte(1) 
		write_byte(0) 
		write_byte(0) 
		write_byte(255) 
		write_byte(255)
		write_byte(0)
		message_end()
	}
	else
	{
		static origin[3]
		get_user_origin(id, origin)
		message_begin(MSG_BROADCAST, SVC_TEMPENTITY)
		write_byte(TE_BEAMCYLINDER)
		write_coord(origin[0])
		write_coord(origin[1])
		write_coord(origin[2]-20)	
		write_coord(origin[0]) 
		write_coord(origin[1])
		write_coord(origin[2]+200)
		write_short(BeaconSprite)
		write_byte(0)
		write_byte(1)
		write_byte(6)
		write_byte(2) 
		write_byte(1) 
		write_byte(255) 
		write_byte(0) 
		write_byte(0) 
		write_byte(255)
		write_byte(0)
		message_end()
	}
	set_task(1.0, "Beacon", id)	
	return PLUGIN_CONTINUE
}
/*================================================================================
	Стоки...
	Цветной чат
=================================================================================*/
stock ChatColor(const id, const input[], any:...)
{
	new count = 1, players[32]
	static msg[191]
	vformat(msg, 190, input, 3)
	replace_all(msg, 190, "!g", "^4")
	replace_all(msg, 190, "!y", "^1")
	replace_all(msg, 190, "!team", "^3")
	if (id) players[0] = id
	else get_players(players, count, "ch")
	for (new i = 0; i < count; i++)
	{
		if (is_user_connected(players[i]))
		{
			message_begin(MSG_ONE_UNRELIABLE, SayText, _, players[i])
			write_byte(players[i])
			write_string(msg)
			message_end()
		}
	}
	return PLUGIN_CONTINUE
}
/*================================================================================
	Сообщение о смерти
=================================================================================*/
stock DeathMsg(killer_id, victim_id, headshot, weaponname[])
{
	message_begin(MSG_ALL, get_user_msgid("DeathMsg"))
	write_byte(killer_id)
	write_byte(victim_id)
	write_byte(headshot)
	write_string(weaponname)
	message_end()
	return PLUGIN_CONTINUE
}
/*================================================================================
	Взять количество флагов
=================================================================================*/
stock GetFlagsNum(pcvar)
{
	new Duels = GetFlags(pcvar)
	new DuelsNum = 0
	for(new a = 0; a < DCOUNT; a++)
	{
		if(Duels & (1 << a))
		{
			DuelsNum++
		}
	}
	return DuelsNum
}
/*================================================================================
	Взять флаги
=================================================================================*/
stock GetFlags(pcvar)
{
	new Flags[32]
	get_pcvar_string(pcvar, Flags, 31)
	return read_flags(Flags)
}
/*================================================================================
	Количество спецназа
=================================================================================*/
stock GetCTsNum(alive)
{
	new CTsNum = 0
	for (new id = 1; id <= MaxPlayers; id++)
	{
		if(!is_user_connected(id))
		{ 
			continue
		}
		if(alive)
		{
			if(cs_get_user_team(id) == CS_TEAM_CT && is_user_alive(id))
			{ 
				CTsNum++
			} 
		}
		else
		{
			if(cs_get_user_team(id) == CS_TEAM_CT)
			{ 
				CTsNum++
			} 
		}
	}
	return CTsNum
}
/*================================================================================
	Количество террористов
=================================================================================*/
stock GetTsNum(alive)
{
	new TsNum = 0
	for (new id = 1; id <= MaxPlayers; id++)
	{
		if(!is_user_connected(id) || is_user_bot(id))
		{ 
			continue
		}
		if(alive)
		{
			if(cs_get_user_team(id) == CS_TEAM_T && is_user_alive(id))
			{ 
				TsNum++
			} 
		}
		else
		{
			if(cs_get_user_team(id) == CS_TEAM_T)
			{ 
				TsNum++
			} 
		}
	}
	return TsNum
}
/*================================================================================
	Убить игрока
=================================================================================*/
stock Kill(id)
{
	user_kill(id, 1)
	return PLUGIN_CONTINUE
}
/*================================================================================
	Copyright 2010 (c) NoName. Special for http://nowebsite and NoName.
=================================================================================*/